@extends('layouts.core.frontend_dark', [
    'subscriptionPage' => true,
])

@section('title', trans('messages.subscriptions'))

@section('menu_title')
    @include('subscription._title')
@endsection

@section('menu_right')
    @if ($invoice->type !== \Acelle\Model\InvoiceNewSubscription::TYPE_NEW_SUBSCRIPTION)
        <li class="nav-item d-flex align-items-center">
            <a  href="{{ action('SubscriptionController@index') }}"
                class="nav-link py-3 lvl-1">
                <i class="material-symbols-rounded me-2">arrow_back</i>
                <span>{{ trans('messages.go_back') }}</span>
            </a>
        </li>
    @endif

    @include('layouts.core._top_activity_log')
    @include('layouts.core._menu_frontend_user', [
        'menu' => 'subscription',
    ])
@endsection

@section('content')
    <div class="container mt-4 mb-5">
        <div class="row">
            <div class="col-md-6">
                <div class="my-4 py-4">
                    <svg style="width:120px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 162.3 132.9"><defs><linearGradient id="linear-gradient" x1="111.65" y1="117.9" x2="125.88" y2="65.55" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#171717"/><stop offset="1" stop-color="#2d2d2d"/></linearGradient><linearGradient id="linear-gradient-2" x1="140.42" y1="104.77" x2="86.09" y2="104.77" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#2d2d2d"/><stop offset="0.32" stop-color="#3b3b3b"/><stop offset="0.61" stop-color="#171717"/><stop offset="0.83" stop-color="#262626"/><stop offset="0.99" stop-color="#1e1e1e"/></linearGradient></defs><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><path d="M133.6,52a36.8,36.8,0,0,1-11,10.1l-4.8,2.8a4.5,4.5,0,0,0-2,3.6c.1,1,.9,9.3,1.5,14.9a8.7,8.7,0,0,0,5.9,7.5c9.2,3.3,16.4,2.8,16.4,13.9v4.1h0c.3,3.6-2.2,7.3-7,10.1s-11.5,4.4-18.6,4.4h0c-7.1,0-13.8-1.6-18.8-4.5s-7.5-6.5-7.1-10.3h0v-3.7c0-11.2,7.4-10.8,16.7-14.1a9,9,0,0,0,6-7.5c.6-5.6,1.5-13.9,1.5-14.8a4.3,4.3,0,0,0-2-3.7L105.5,62a35.6,35.6,0,0,1-10.4-8.8Z" style="fill:#fc0"/><ellipse cx="114" cy="48.3" rx="20.6" ry="12" style="fill:#ffde17"/><path d="M111,91.8s-15.3,5.7-17.8,10.8-.5,8.6,4.5,8.9S99,103.1,111,91.8Z" style="fill:#ffde17"/><ellipse cx="119.2" cy="117.2" rx="37.3" ry="15.7" style="fill:#adadad;opacity:0.2"/><polygon points="111.6 59.5 111.6 96.3 55 64.3 55 27.5 111.6 59.5" style="fill:#a7a7a7"/><path d="M112.3,97.6,54.2,64.7V26.2L112.3,59ZM55.8,63.8l55,31.2V59.9l-55-31.1Z" style="fill:#e5e5e5"/><polygon points="13.4 68.7 13.4 99.1 95.1 51.5 68.2 36.3 13.4 68.7" style="fill:#c7c7c7"/><polygon points="10.4 66.9 13.5 68.7 68.2 36.3 65 34.4 10.4 66.9" style="fill:#e5e5e5"/><path d="M78.8,48.1v3.4l-22.6-13a1.2,1.2,0,0,0-1.8,1V75l43.1,25.1a2.9,2.9,0,0,0,3.2-.1l.9-.5A3,3,0,0,0,103,97V62a3.4,3.4,0,0,0-1.6-2.9l-20.9-12A1.1,1.1,0,0,0,78.8,48.1Z" style="fill:#404040"/><path d="M55.7,38.9l22.6,13v-.7L56.2,38.5a1.2,1.2,0,0,0-1.6.3A1.4,1.4,0,0,1,55.7,38.9Z" style="fill:#616161"/><path d="M101.4,59.1l-20.9-12a1.1,1.1,0,0,0-1.5.4,1.1,1.1,0,0,1,1.1,0l20.8,12a3.4,3.4,0,0,1,1.6,2.9v35a2.8,2.8,0,0,1-.8,2A2.8,2.8,0,0,0,103,97V62A3.4,3.4,0,0,0,101.4,59.1Z" style="fill:#616161"/><polygon points="52.2 71.3 100.8 99.4 100.8 68.5 52.2 40.5 52.2 71.3" style="fill:#fff"/><path d="M52.5,74.1l45,26a3.4,3.4,0,0,0,3.1,0l.3-.2-.3.2A1.1,1.1,0,0,1,99.1,99V74.1a3.4,3.4,0,0,0-1.7-2.8L52.2,45.2a1.2,1.2,0,0,0-1.8,1V70.4A4.4,4.4,0,0,0,52.5,74.1Z" style="fill:#404040"/><path d="M100.6,100.1A1.1,1.1,0,0,1,99.1,99V74.1a3.4,3.4,0,0,0-1.7-2.8L52.2,45.2a1.2,1.2,0,0,0-1.5.3,1.1,1.1,0,0,1,1.1,0L97,71.6a3.3,3.3,0,0,1,1.6,2.8V99.3a1.1,1.1,0,0,0,1,1.1,1.9,1.9,0,0,0,1-.3l.3-.2Z" style="fill:#616161"/><path d="M69,53.8v3.3l-22.6-13a1.2,1.2,0,0,0-1.8,1V80.7l43.1,25a3.3,3.3,0,0,0,3.3,0l.9-.6a2.8,2.8,0,0,0,1.3-2.4V67.6a3.1,3.1,0,0,0-1.6-2.8L70.8,52.7A1.3,1.3,0,0,0,69,53.8Z" style="fill:#404040"/><path d="M45.9,44.5,68.5,57.6v-.7L46.4,44.1a1.3,1.3,0,0,0-1.6.4A1.1,1.1,0,0,1,45.9,44.5Z" style="fill:#616161"/><path d="M91.6,64.8,70.8,52.7a1.2,1.2,0,0,0-1.6.4,1.1,1.1,0,0,1,1.1.1l20.8,12A3.2,3.2,0,0,1,92.7,68v35.1A2.6,2.6,0,0,1,92,105a2.9,2.9,0,0,0,1.2-2.3V67.6A3.1,3.1,0,0,0,91.6,64.8Z" style="fill:#616161"/><polygon points="42.4 77 91 105.1 91 74.2 42.4 46.1 42.4 77" style="fill:#fff"/><path d="M42.8,79.7l45,26a2.9,2.9,0,0,0,3,0h0a1.1,1.1,0,0,1-1.5-1.1V79.8a3.4,3.4,0,0,0-1.6-2.9L42.5,50.8a1.3,1.3,0,0,0-1.8,1.1V76.1A4.1,4.1,0,0,0,42.8,79.7Z" style="fill:#404040"/><path d="M90.8,105.7a1.1,1.1,0,0,1-1.5-1.1V79.8a3.4,3.4,0,0,0-1.6-2.9L42.5,50.8a1.2,1.2,0,0,0-1.5.3,1.2,1.2,0,0,1,1,0L87.2,77.2a3.4,3.4,0,0,1,1.7,2.9V105a1.2,1.2,0,0,0,.9,1.1l1-.4h0Z" style="fill:#616161"/><path d="M59.3,59.5v3.4l-22.5-13a1.2,1.2,0,0,0-1.8,1V86.4l43.1,25.1a2.9,2.9,0,0,0,3.2-.1l.9-.5a3,3,0,0,0,1.4-2.5V73.3A3.3,3.3,0,0,0,82,70.5l-20.9-12A1.2,1.2,0,0,0,59.3,59.5Z" style="fill:#666"/><path d="M36.3,50.3l22.6,13v-.7L36.8,49.9a1.1,1.1,0,0,0-1.6.3A1.4,1.4,0,0,1,36.3,50.3Z" style="fill:#949494"/><path d="M82,70.5l-20.9-12a1.1,1.1,0,0,0-1.5.4.9.9,0,0,1,1,0l20.9,12a3.4,3.4,0,0,1,1.6,2.9v35a2.8,2.8,0,0,1-.8,2,2.8,2.8,0,0,0,1.3-2.4V73.3A3.3,3.3,0,0,0,82,70.5Z" style="fill:#949494"/><polygon points="32.7 82.7 81.4 110.8 81.4 79.9 32.7 51.8 32.7 82.7" style="fill:#fff"/><path d="M33.1,85.5l45,26a3.4,3.4,0,0,0,3.1,0l.3-.2-.3.2a1.2,1.2,0,0,1-1.6-1.1V85.5A3.3,3.3,0,0,0,78,82.7L32.8,56.6a1.2,1.2,0,0,0-1.8,1V81.8A4.4,4.4,0,0,0,33.1,85.5Z" style="fill:#666"/><path d="M81.2,111.5a1.2,1.2,0,0,1-1.6-1.1V85.5A3.3,3.3,0,0,0,78,82.7L32.8,56.6a1.2,1.2,0,0,0-1.5.3,1.1,1.1,0,0,1,1.1,0L77.6,83a3.3,3.3,0,0,1,1.6,2.8v24.9a1.1,1.1,0,0,0,1,1.1,1.9,1.9,0,0,0,1-.3l.3-.2Z" style="fill:#949494"/><path d="M49.7,65.3v3.4L27.1,55.6a1.2,1.2,0,0,0-1.8,1.1V92.2l43.1,25a3.2,3.2,0,0,0,3.3,0l.9-.6a2.9,2.9,0,0,0,1.4-2.4V79.1a3.3,3.3,0,0,0-1.7-2.8l-20.8-12A1.2,1.2,0,0,0,49.7,65.3Z" style="fill:#747474"/><path d="M26.6,56,49.2,69.1v-.7L27.1,55.6a1.3,1.3,0,0,0-1.6.4A1.1,1.1,0,0,1,26.6,56Z" style="fill:#a3a3a3"/><path d="M72.3,76.3l-20.8-12a1.1,1.1,0,0,0-1.6.3,1.4,1.4,0,0,1,1.1.1l20.8,12a3.4,3.4,0,0,1,1.7,2.8v35.1a3.2,3.2,0,0,1-.8,2,3.1,3.1,0,0,0,1.3-2.4V79.1A3.3,3.3,0,0,0,72.3,76.3Z" style="fill:#a3a3a3"/><polygon points="23.1 88.5 71.7 116.6 71.7 85.7 23.1 57.6 23.1 88.5" style="fill:#fff"/><path d="M23.5,91.2l45,26a2.9,2.9,0,0,0,3,.1l.3-.2h-.3a1.1,1.1,0,0,1-1.5-1V91.3a3.1,3.1,0,0,0-1.6-2.8L23.2,62.4a1.2,1.2,0,0,0-1.8,1V87.6A4.1,4.1,0,0,0,23.5,91.2Z" style="fill:#747474"/><path d="M71.5,117.2a1.1,1.1,0,0,1-1.5-1V91.3a3.1,3.1,0,0,0-1.6-2.8L23.2,62.4a1.2,1.2,0,0,0-1.5.2,1.2,1.2,0,0,1,1,.1L67.9,88.8a3.2,3.2,0,0,1,1.7,2.8v24.9a1.1,1.1,0,0,0,.9,1.1l1-.3.3-.2Z" style="fill:#a3a3a3"/><polygon points="57.6 103.4 57.6 126.2 110.7 94.6 110.7 71.7 57.6 103.4" style="fill:#c7c7c7"/><polygon points="40.1 110.2 43.3 112 110.7 72.2 110.7 68.4 40.1 110.2" style="fill:#e5e5e5"/><polygon points="63.5 93.7 63.5 132.2 67 130.2 67 91.7 63.5 93.7" style="fill:#616161"/><polygon points="63.5 93.7 63.5 132.2 0 95.2 0 56.7 63.5 93.7" style="fill:gray"/><polygon points="2.1 94 2.1 60.3 61.5 94.9 61.5 128.6 2.1 94" style="fill:#a7a7a7"/><polygon points="0 56.7 63.5 93.7 67 91.7 3.4 54.7 0 56.7" style="fill:#a7a7a7"/><polygon points="0.5 56.5 0.5 57.5 63.2 94 63.2 131.4 64 131.9 64 93.4 0.5 56.5" style="fill:#c7c7c7"/><path d="M36.7,89a6.9,6.9,0,0,0-3.1-5.4,2.3,2.3,0,0,0-2.2-.3h0l-1.6.9.2.4a3.6,3.6,0,0,0-.2,1.1A6.7,6.7,0,0,0,32.9,91a1.7,1.7,0,0,0,1.1.4l.2.4,1.5-.8A2.1,2.1,0,0,0,36.7,89Z" style="fill:#404040"/><path d="M35.5,90.5a9,9,0,0,0-4-7,3,3,0,0,0-2.8-.4l-.9.5.3.5a5.2,5.2,0,0,0-.2,1.4,8.8,8.8,0,0,0,4.1,7,2.4,2.4,0,0,0,1.3.5l.4.5.6-.3C35.2,92.8,35.5,91.9,35.5,90.5Z" style="fill:#616161"/><path d="M34.8,90.9c0,2.6-1.9,3.7-4.1,2.4a9,9,0,0,1-4.1-7.1c0-2.6,1.8-3.6,4.1-2.3A9.2,9.2,0,0,1,34.8,90.9Z" style="fill:gray"/><path d="M30.8,83.9a3.4,3.4,0,0,0-2.2-.6,4.8,4.8,0,0,1,2.1.6,9.2,9.2,0,0,1,4.1,7c0,1.7-.8,2.7-1.9,2.9,1.2-.1,2-1.2,2-2.9A8.8,8.8,0,0,0,30.8,83.9Z" style="fill:#a7a7a7"/><path d="M145.9,109.6H81.8v3.5h0v.2c0,10.3,14.4,18.7,32,18.7s32.1-8.4,32.1-18.7v-.2h0Z" style="fill:#2b2b2b"/><ellipse cx="113.8" cy="109.7" rx="32" ry="18.6" style="fill:#616161"/><path d="M113.8,128.3c-17.5,0-31.7-8.2-32-18.3v.3c0,10.3,14.4,18.7,32,18.7s32.1-8.4,32.1-18.7a.4.4,0,0,0-.1-.3C145.5,120.1,131.3,128.3,113.8,128.3Z" style="fill:#c7c7c7"/><ellipse cx="113.8" cy="109.8" rx="27" ry="15.6" style="fill:url(#linear-gradient)"/><path d="M113.8,105.2c11.6,0,21.5,4.2,25.3,10.1a10,10,0,0,0,1.8-5.5c0-8.6-12.1-15.6-27.1-15.6s-27,7-27,15.6a10,10,0,0,0,1.8,5.5C92.4,109.4,102.2,105.2,113.8,105.2Z" style="fill:url(#linear-gradient-2)"/><path d="M147.6,91.1c-.2,0-.3-.1-.4-.3l-.9-1.8a.5.5,0,0,1,.2-.6.4.4,0,0,1,.7.2l.9,1.8a.6.6,0,0,1-.3.7Zm-2.3-4.4c-.2,0-.3-.1-.4-.3l-1-1.7a.5.5,0,0,1,.1-.7.7.7,0,0,1,.7.2l1,1.7a.5.5,0,0,1-.1.7Zm-2.7-4.2-.4-.2L141,80.7c-.1-.3-.1-.6.1-.7s.6-.2.7,0l1.2,1.7a.5.5,0,0,1-.1.7Zm-3.1-4c-.1,0-.2,0-.3-.2a18.5,18.5,0,0,0-1.4-1.4.8.8,0,0,1,.1-.8.6.6,0,0,1,.7.1l1.3,1.5a.5.5,0,0,1,0,.7Zm-3.4-3.6-.3-.2a7,7,0,0,1-1.3-1.7c-.2-.2-.1-.5.2-.7a.5.5,0,0,1,.6.2,6.1,6.1,0,0,0,1.2,1.5.5.5,0,0,1,0,.7A.5.5,0,0,1,136.1,74.9Zm-2.2-4.4c-.2,0-.5-.2-.5-.4a6.6,6.6,0,0,1-.1-1.4v-.8a.7.7,0,0,1,.6-.4c.3,0,.5.3.4.5v.7a4.9,4.9,0,0,0,.1,1.2.5.5,0,0,1-.4.6Zm.7-4.9h-.2a.7.7,0,0,1-.2-.7,9.4,9.4,0,0,1,1.2-1.8.5.5,0,0,1,.7.7,13,13,0,0,0-1,1.5A.5.5,0,0,1,134.6,65.6Zm3.2-3.8h-.3a.5.5,0,0,1,0-.7l1.3-1.5a.5.5,0,0,1,.7-.1.5.5,0,0,1,0,.7l-1.3,1.5Zm3.3-3.8h-.3a.4.4,0,0,1-.1-.7l1.2-1.6a.5.5,0,0,1,.7-.1c.2.1.2.4.1.7l-1.2,1.6Zm2.8-4.1h-.2c-.3-.1-.3-.4-.2-.7s.7-1.1,1.1-1.7a.4.4,0,0,1,.6-.1c.3.1.4.4.2.6l-1,1.8Zm2.6-4.3h-.3a.6.6,0,0,1-.2-.7l.9-1.7a.5.5,0,0,1,.7-.3.7.7,0,0,1,.2.7l-.9,1.8A.5.5,0,0,1,146.5,49.6Zm2.1-4.6h-.2a.4.4,0,0,1-.3-.6c.3-.7.5-1.3.7-1.9a.5.5,0,0,1,1,.4l-.8,1.8C149,44.9,148.8,45,148.6,45Zm1.7-4.6h-.2a.5.5,0,0,1-.3-.6l.6-1.9c0-.3.3-.4.6-.3s.4.3.3.6a13.3,13.3,0,0,1-.5,1.9A.7.7,0,0,1,150.3,40.4Zm1.3-4.9h-.1c-.3-.1-.5-.3-.4-.6s.3-1.3.4-1.9a.4.4,0,0,1,.6-.4c.2,0,.4.3.4.5a17.7,17.7,0,0,0-.4,2A.5.5,0,0,1,151.6,35.5Zm.8-4.9h0a.6.6,0,0,1-.5-.6l.3-1.9a.5.5,0,0,1,.5-.5.6.6,0,0,1,.5.6l-.3,2A.5.5,0,0,1,152.4,30.6Zm.4-5h0a.5.5,0,0,1-.5-.5,13.4,13.4,0,0,0,.1-2,.5.5,0,1,1,1,0,12.7,12.7,0,0,1-.1,2A.5.5,0,0,1,152.8,25.6Z" style="fill:#868686"/><path d="M160.2,110.2a.5.5,0,0,1-.5-.5v-.9c0-.2.2-.5.4-.5h.1a.5.5,0,0,1,.5.5v.9A.5.5,0,0,1,160.2,110.2Zm-.2-3.9a.5.5,0,0,1-.5-.4c-.1-.7-.1-1.3-.2-2s.1-.5.4-.5.5.1.6.4.1,1.3.2,2a.5.5,0,0,1-.5.5Zm-.7-4.9c-.2,0-.5-.2-.5-.4s-.3-1.3-.4-1.9.1-.6.3-.6.6.1.6.3.3,1.3.5,2a.5.5,0,0,1-.4.6ZM158,96.6a.4.4,0,0,1-.4-.4,14.6,14.6,0,0,0-.7-1.9c-.1-.2.1-.5.3-.6a.5.5,0,0,1,.7.3l.6,1.9a.4.4,0,0,1-.3.6Zm-1.7-4.7a.5.5,0,0,1-.5-.3,9.8,9.8,0,0,0-.8-1.8.5.5,0,0,1,.3-.7.5.5,0,0,1,.6.2l.9,1.9a.4.4,0,0,1-.3.6Zm-2.2-4.5a.5.5,0,0,1-.4-.3,9.5,9.5,0,0,0-1-1.7.6.6,0,0,1,.2-.7.4.4,0,0,1,.7.2l1,1.7a.6.6,0,0,1-.2.7ZM151.6,83a.4.4,0,0,1-.4-.2,16.3,16.3,0,0,0-1.1-1.7.5.5,0,0,1,.2-.7.7.7,0,0,1,.7.2l1.1,1.7a.7.7,0,0,1-.2.7Zm-2.8-4.1-.4-.2-1.1-1.6a.4.4,0,0,1,.1-.7.5.5,0,0,1,.7.1l1.1,1.6a.5.5,0,0,1-.1.7Zm-3-4-.4-.2-1.2-1.6a.5.5,0,0,1,.1-.7.6.6,0,0,1,.7.1l1.2,1.6a.4.4,0,0,1-.1.7Zm-2.7-4.1c-.3,0-.4-.2-.5-.4a7.8,7.8,0,0,1-.4-2.1.5.5,0,0,1,.5-.5h0a.5.5,0,0,1,.5.5,5.7,5.7,0,0,0,.3,1.8c.1.3,0,.6-.3.6Zm.3-4.9h-.2a.6.6,0,0,1-.3-.7l.9-1.4.3-.4a.5.5,0,0,1,.7,0,.5.5,0,0,1,.1.7l-.3.4a4.4,4.4,0,0,0-.8,1.1C143.8,65.8,143.6,65.9,143.4,65.9Zm2.9-4.1H146a.5.5,0,0,1-.1-.7l1.1-1.7a.5.5,0,0,1,.7-.1.5.5,0,0,1,.1.7l-1.1,1.6C146.6,61.8,146.5,61.8,146.3,61.8Zm2.7-4.2h-.3a.7.7,0,0,1-.2-.7,16.2,16.2,0,0,0,1-1.8.5.5,0,0,1,.6-.2.5.5,0,0,1,.3.7l-1,1.8Z" style="fill:#c7c7c7"/><path d="M141.9,108.7v-3.9a37.6,37.6,0,0,0-20-33.2L119.1,70a1.8,1.8,0,0,1-.1-3.1l4.7-2.9a37.6,37.6,0,0,0,18.2-32.2V20.4H85.8V31.5a37.7,37.7,0,0,0,18.5,32.4l4.8,2.9a1.8,1.8,0,0,1,0,3.2l-3,1.5a37.6,37.6,0,0,0-20.3,33.4v3.6c-.4,4.5,2.3,9.1,8.2,12.5,11,6.3,28.8,6.4,39.8.1C139.6,117.7,142.3,113.2,141.9,108.7Z" style="fill:#f6f6f6"/><path d="M134,52a35.6,35.6,0,0,1-11.1,10l-4.7,2.9a4.2,4.2,0,0,0-2,3.6c0,1,.9,9.2,1.4,14.9a9.1,9.1,0,0,0,5.9,7.5c9.2,3.3,16.4,2.8,16.4,13.8V109c.3,3.6-2.2,7.3-7,10.1s-11.5,4.4-18.6,4.4h0c-7.2,0-13.9-1.6-18.9-4.5s-7.4-6.6-7.1-10.3h.1v-3.7c0-11.2,7.3-10.8,16.7-14.1a8.7,8.7,0,0,0,5.9-7.5c.7-5.6,1.5-13.9,1.6-14.9a4.3,4.3,0,0,0-2-3.6L105.8,62a38.9,38.9,0,0,1-10.4-8.8Z" style="fill:#fc0"/><ellipse cx="114.4" cy="48.3" rx="20.6" ry="12" style="fill:#ffde17"/><path d="M111.4,91.8s-15.3,5.7-17.9,10.8-.4,8.6,4.5,8.9S99.4,103.1,111.4,91.8Z" style="fill:#ffde17"/><path d="M145.9,18.5H81.8V22h0v.2c0,10.3,14.4,18.7,32,18.7s32.1-8.4,32.1-18.7V22h0Z" style="fill:#2b2b2b"/><ellipse cx="113.8" cy="18.6" rx="32" ry="18.6" style="fill:#616161"/><path d="M113.8,37.2c-17.5,0-31.7-8.1-32-18.3v.3c0,10.3,14.4,18.7,32,18.7s32.1-8.4,32.1-18.7a.4.4,0,0,0-.1-.3C145.5,29.1,131.3,37.2,113.8,37.2Z" style="fill:#c7c7c7"/><path d="M159.8,111.9h-.1c-.2,0-.3-.2-.4-.4l-1-3.8a.4.4,0,0,1,.4-.6c.2-.1.5.1.6.3l.7,2.6,1.3-2.5c.1-.3.4-.3.7-.2a.6.6,0,0,1,.2.7l-2,3.6C160.2,111.8,160,111.9,159.8,111.9Z" style="fill:#c7c7c7"/></g></g></svg>
                </div>
                <h2>{!! trans('messages.invoice.pending') !!}</h2>  
                <p> {!! trans('messages.invoice.pending.wording') !!}</p>

                <div class="mt-4">
                    <a onclick="addButtonMask($(this))" link-method="POST" href="{{ action('SubscriptionController@verifyPendingTransaction', [
                        'invoice_uid' => $invoice->uid,
                    ]) }}" class="btn btn-secondary">
                        <span class="material-symbols-rounded me-1">restart_alt</span>
                        {{ trans('messages.subscription.verify_transaction') }}
                    </a>
                </div>
            </div>
            <div class="col-md-2"></div>
            <div class="col-md-4">
                <div class="card shadow-sm rounded-3 px-2 py-2">
                    <div class="card-body p-4">
                        @include('invoices.bill', [
                            'bill' => $invoice->mapType()->getBillingInfo(),
                        ])
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
